/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWException;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSystemAdministration;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWUserInfo;
import filenet.vw.api.VWXMLConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.IVWConfigTreeNode;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigAppSpaceNode;
import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.VWConfigEventLogNode;
import filenet.vw.toolkit.admin.VWConfigFolderNode;
import filenet.vw.toolkit.admin.VWConfigQueueNode;
import filenet.vw.toolkit.admin.VWConfigRosterNode;
import filenet.vw.toolkit.admin.VWConfigVWServiceNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class VWConfigRegionNode
extends VWConfigBaseNode
implements IVWConfigTreeNode {
    public static final int DISCARD_NO_REFETCH = 1;
    public static final int DISCARD_REFETCH = 2;
    public static final ImageIcon LogoffIcon32 = VWImageLoader.createImageIcon("iso_logoff_32.gif");
    public static final ImageIcon LogoffIcon16 = VWImageLoader.createImageIcon("iso_logoff_16.gif");
    public static final ImageIcon LogonIcon32 = VWImageLoader.createImageIcon("iso_logon_32.gif");
    public static final ImageIcon LogonIcon16 = VWImageLoader.createImageIcon("iso_logon_16.gif");
    protected VWConfigFolderNode m_queueFolder = null;
    protected VWConfigFolderNode m_componentFolder = null;
    protected VWConfigFolderNode m_userQueueFolder = null;
    protected VWConfigFolderNode m_rosterFolder = null;
    protected VWConfigFolderNode m_eventlogFolder = null;
    protected VWConfigFolderNode m_appSpaceFolder = null;
    protected VWSystemConfiguration m_configuration = null;
    protected VWSystemAdministration m_admin = null;
    protected String m_router = null;
    protected String m_hostName = null;
    protected int m_port = 0;
    protected String m_baseURL = null;
    protected int m_importOption = -1;
    protected boolean m_bInitialized = false;

    public VWConfigRegionNode(String name, String router, int IR, String hostName, String serviceName, int port, String baseURL) {
        super(name, 19, VWConfigActionCommand.ACMD_REGION);
        this.setIcon32(LogoffIcon32);
        this.setIcon16(LogoffIcon16);
        this.m_router = router;
        this.m_regionID = IR;
        this.m_hostName = hostName;
        this.m_serviceName = serviceName;
        this.m_port = port;
        this.m_baseURL = baseURL;
        this.m_eventStatus = 4;
    }

    public VWConfigRegionNode(String name) {
        super(name, 19, VWConfigActionCommand.ACMD_REGION);
        this.setIcon32(LogoffIcon32);
        this.setIcon16(LogoffIcon16);
        this.m_eventStatus = 4;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public int getRouterPort() {
        return this.m_port;
    }

    public String getRouterName() {
        return this.m_router;
    }

    public void setLogonIcon(boolean b) {
        if (b) {
            this.setIcon32(LogonIcon32);
            this.setIcon16(LogonIcon16);
        } else {
            this.setIcon32(LogoffIcon32);
            this.setIcon16(LogoffIcon16);
        }
    }

    public void logon(VWSessionInfo sessionInfo) throws Exception {
        try {
            this.m_sessionInfo = sessionInfo;
            this.m_bInitialized = this.m_sessionInfo.getSession().isRegionInitialized();
            this.m_configuration = this.m_sessionInfo.getSession().fetchSystemConfiguration();
            this.m_admin = this.m_sessionInfo.getSession().fetchSystemAdministration();
            if (this.m_bInitialized) {
                this.setupRegionConfig();
            }
            VWConfigVWServiceNode serviceNode = (VWConfigVWServiceNode)this.getParent();
            serviceNode.registRegion(true);
            serviceNode.setSysAdmin(this.m_admin);
            serviceNode.setSessionInfo(sessionInfo);
            this.setLogonIcon(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void logoff() {
        try {
            if (this.m_sessionInfo != null) {
                RegionThread rThread = new RegionThread("region logoff thread", this.m_sessionInfo);
                rThread.start();
                VWConfigVWServiceNode serviceNode = (VWConfigVWServiceNode)this.getParent();
                serviceNode.registRegion(false);
                this.releaseAllChildrenResources();
                this.setLogonIcon(false);
                this.m_sessionInfo = null;
                this.m_admin = null;
                this.m_bInitialized = false;
                serviceNode.refreshSessionInfo();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isRegionInitialized() {
        return this.m_bInitialized;
    }

    public void clear() {
        try {
            if (this.m_sessionInfo != null) {
                this.removeAllChildren();
                VWConfigVWServiceNode serviceNode = (VWConfigVWServiceNode)this.getParent();
                serviceNode.registRegion(false);
                this.setLogonIcon(false);
                this.m_sessionInfo = null;
                this.m_admin = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void initRegion() throws Exception {
        try {
            if (this.m_sessionInfo != null) {
                String key;
                VWAttributeInfo adminAttributes;
                String webServer;
                VWAttributeInfo vwAttributeInfo;
                Integer webAppId;
                if (this.m_admin == null) {
                    this.m_admin = this.m_sessionInfo.getSession().fetchSystemAdministration();
                }
                this.m_admin.initializeRegion();
                if (this.m_baseURL != null && (webAppId = (Integer)(vwAttributeInfo = this.m_configuration.getAttributeInfo()).getFieldValue("F_WebApp")) != null && (webServer = (String)(adminAttributes = this.m_admin.getAttributeInfo()).getFieldValue(key = "F_WebServer." + webAppId.toString())) == null) {
                    adminAttributes.setFieldValue(key, this.m_baseURL);
                    this.m_admin.setAttributeInfo(adminAttributes);
                    this.m_admin.commit();
                }
                if (this.isDirty()) {
                    this.discardChanges(1);
                }
                this.m_bInitialized = true;
                this.releaseAllChildrenResources();
                this.m_configuration = this.m_sessionInfo.getSession().fetchSystemConfiguration();
                this.setupRegionConfig();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void setupRegionConfig() throws Exception {
        if (this.m_sessionInfo == null) {
            return;
        }
        this.m_queueFolder = new VWConfigFolderNode(VWResource.WorkQueues, 20, VWConfigActionCommand.ACMD_WORK_QUEUE_FOLDER);
        this.m_queueFolder.setSessionInfo(this.m_sessionInfo);
        this.m_queueFolder.setServiceName(this.m_serviceName);
        this.m_queueFolder.setRegionID(this.m_regionID);
        this.m_queueFolder.setServerID(0);
        this.add(this.m_queueFolder);
        this.m_componentFolder = new VWConfigFolderNode(VWResource.ComponentQueues, 24, VWConfigActionCommand.ACMD_COMP_QUEUE_FOLDER);
        this.m_componentFolder.setSessionInfo(this.m_sessionInfo);
        this.m_componentFolder.setServiceName(this.m_serviceName);
        this.m_componentFolder.setRegionID(this.m_regionID);
        this.m_componentFolder.setServerID(0);
        this.add(this.m_componentFolder);
        this.m_userQueueFolder = new VWConfigFolderNode(VWResource.UserQueues, 21, VWConfigActionCommand.ACMD_USER_QUEUE_FOLDER);
        this.m_userQueueFolder.setSessionInfo(this.m_sessionInfo);
        this.m_userQueueFolder.setServiceName(this.m_serviceName);
        this.m_userQueueFolder.setRegionID(this.m_regionID);
        this.add(this.m_userQueueFolder);
        this.m_rosterFolder = new VWConfigFolderNode(VWResource.WorkflowRosters, 22, VWConfigActionCommand.ACMD_ROSTER_FOLDER);
        this.m_rosterFolder.setSessionInfo(this.m_sessionInfo);
        this.m_rosterFolder.setServiceName(this.m_serviceName);
        this.m_rosterFolder.setRegionID(this.m_regionID);
        this.m_rosterFolder.setServerID(0);
        this.add(this.m_rosterFolder);
        this.m_eventlogFolder = new VWConfigFolderNode(VWResource.EventLogs, 23, VWConfigActionCommand.ACMD_EVENTLOG_FOLDER);
        this.m_eventlogFolder.setSessionInfo(this.m_sessionInfo);
        this.m_eventlogFolder.setServiceName(this.m_serviceName);
        this.m_eventlogFolder.setRegionID(this.m_regionID);
        this.add(this.m_eventlogFolder);
        this.m_appSpaceFolder = new VWConfigFolderNode(VWResource.ApplicationSpaces, 25, VWConfigActionCommand.ACMD_APPSPACE_FOLDER);
        this.m_appSpaceFolder.setSessionInfo(this.m_sessionInfo);
        this.m_appSpaceFolder.setServiceName(this.m_serviceName);
        this.m_appSpaceFolder.setRegionID(this.m_regionID);
        this.add(this.m_appSpaceFolder);
        this.addRegionChildNodes();
    }

    protected void addRegionChildNodes() throws VWException {
        this.m_userQueueFolder.removeAllChildren();
        this.m_queueFolder.removeAllChildren();
        this.m_componentFolder.removeAllChildren();
        VWQueueDefinition[] queueDefs = this.m_configuration.getQueueDefinitions();
        if (queueDefs != null) {
            for (int i = 0; i < queueDefs.length; ++i) {
                VWConfigQueueNode aQueueNode;
                if (queueDefs[i].getQueueType() == 2) {
                    aQueueNode = new VWConfigQueueNode(this.m_sessionInfo, queueDefs[i], this.m_serviceName, this.m_regionID, -1, this.m_configuration);
                    this.m_userQueueFolder.add(aQueueNode, 1);
                    if (!queueDefs[i].hasChanged()) continue;
                    aQueueNode.fireStatusEvent(7);
                    continue;
                }
                aQueueNode = new VWConfigQueueNode(this.m_sessionInfo, queueDefs[i], this.m_serviceName, this.m_regionID, 0, this.m_configuration);
                if (aQueueNode.getType() == 5) {
                    this.m_componentFolder.add(aQueueNode, 1);
                } else {
                    this.m_queueFolder.add(aQueueNode, 1);
                }
                if (!queueDefs[i].hasChanged()) continue;
                aQueueNode.fireStatusEvent(7);
            }
        }
        this.m_rosterFolder.removeAllChildren();
        VWRosterDefinition[] rosterDefs = this.m_configuration.getRosterDefinitions();
        if (rosterDefs != null) {
            for (int i = 0; i < rosterDefs.length; ++i) {
                VWConfigRosterNode aRosterNode = new VWConfigRosterNode(this.m_sessionInfo, rosterDefs[i], this.m_serviceName, this.m_regionID, 0, this.m_configuration);
                this.m_rosterFolder.add(aRosterNode, 1);
                if (!rosterDefs[i].hasChanged()) continue;
                aRosterNode.fireStatusEvent(8);
            }
        }
        this.m_eventlogFolder.removeAllChildren();
        VWLogDefinition[] logDefs = this.m_configuration.getLogDefinitions();
        if (logDefs != null) {
            for (int i = 0; i < logDefs.length; ++i) {
                VWConfigEventLogNode elogNode = new VWConfigEventLogNode(this.m_sessionInfo, logDefs[i], this.m_serviceName, this.m_regionID, this.m_configuration);
                this.m_eventlogFolder.add(elogNode, 1);
                if (!logDefs[i].hasChanged()) continue;
                elogNode.fireStatusEvent(6);
            }
        }
        this.m_appSpaceFolder.removeAllChildren();
        VWApplicationSpaceDefinition[] appSpaceDefs = this.m_configuration.getApplicationSpaceDefinitions();
        if (appSpaceDefs != null) {
            for (int i = 0; i < appSpaceDefs.length; ++i) {
                VWConfigAppSpaceNode appSpaceNode = new VWConfigAppSpaceNode(this.m_sessionInfo, appSpaceDefs[i], this.m_serviceName, this.m_regionID, this.m_configuration);
                this.m_appSpaceFolder.add(appSpaceNode, 1);
                if (!appSpaceDefs[i].hasChanged()) continue;
                appSpaceNode.fireStatusEvent(14);
            }
        }
    }

    public void refresh(boolean bRefetch) throws VWException {
        try {
            if (this.m_sessionInfo == null) {
                return;
            }
            if (bRefetch) {
                if (this.isDirty()) {
                    Object[] OptionsCommitDiscardCancel = new Object[]{VWResource.Commit, VWResource.Discard, VWResource.Skip};
                    String errMsg = VWResource.ConfirmRefresh.toString(this.getServiceName(), this.getRegionIDString());
                    int ret = JOptionPane.showOptionDialog(null, errMsg, VWResource.Refresh, -1, 3, null, OptionsCommitDiscardCancel, OptionsCommitDiscardCancel[1]);
                    if (ret == 0) {
                        this.commitChanges();
                    } else if (ret == 1) {
                        this.clearDirty(true);
                        this.fireStatusEvent(2);
                    } else {
                        return;
                    }
                }
                this.refetchConfiguration();
            }
            this.addRegionChildNodes();
        }
        catch (VWException ex) {
            String exKey = ex.getKey();
            if (exKey != null && exKey.equals("vw.server.getSystemConfigInfoFailed")) {
                JOptionPane.showMessageDialog(null, VWResource.SystemConfigInfoFailed.toString(this.getRegionIDString(), this.getRouterName(), ex.getLocalizedMessage()), VWIDMBaseFactory.instance().getVWString(4).toString(), 2);
                this.clear();
            }
            JOptionPane.showMessageDialog(null, VWResource.FailedToRefreshRegion.toString(this.getRegionIDString(), this.getRouterName(), ex.getLocalizedMessage()), VWIDMBaseFactory.instance().getVWString(4).toString(), 0);
            VWDebug.logException(ex);
        }
    }

    protected void refetchConfiguration() throws VWException {
        this.m_configuration = this.m_sessionInfo.getSession().fetchSystemConfiguration();
        this.m_admin = this.m_sessionInfo.getSession().fetchSystemAdministration();
    }

    public String[] commitChanges() {
        String[] output = null;
        try {
            if (this.m_configuration != null && (output = this.m_configuration.commit()) == null) {
                this.clearDirty(true);
                this.fireStatusEvent(2);
            }
        }
        catch (VWException ex) {
            output = new String[]{ex.getLocalizedMessage()};
            VWDebug.logException(ex);
        }
        return output;
    }

    public boolean discardChanges(int option) throws Exception {
        boolean bSuccess = false;
        this.clearDirty(true);
        this.fireStatusEvent(2);
        if (option == 2) {
            this.refresh(true);
        } else {
            this.removeAllChildren();
        }
        bSuccess = true;
        return bSuccess;
    }

    public String toString() {
        String serviceName = this.getServiceName();
        if (serviceName != null) {
            return VWResource.RegionOnSystem.toString(this.getName(), this.getServiceName());
        }
        return "";
    }

    public VWSystemAdministration getSystemAdministration() {
        return this.m_admin;
    }

    public VWSystemConfiguration getSystemConfiguration() {
        return this.m_configuration;
    }

    public Object clone() {
        VWConfigRegionNode rNode = (VWConfigRegionNode)super.clone();
        rNode.m_configuration = this.m_configuration;
        rNode.m_admin = this.m_admin;
        rNode.m_router = this.m_router;
        rNode.m_hostName = this.m_hostName;
        rNode.m_port = this.m_port;
        rNode.m_baseURL = this.m_baseURL;
        return rNode;
    }

    public IVWtoXML[] getIVWtoXMLItems(boolean bIncludeSysAdmin, boolean bIncludeUserInfo) throws VWException {
        Object[] apiObjects = null;
        Vector<IVWtoXML> objList = new Vector<IVWtoXML>();
        if (bIncludeSysAdmin) {
            this.m_admin = this.m_sessionInfo.getSession().fetchSystemAdministration();
            objList.add(this.m_admin);
        }
        objList.add(this.m_configuration);
        if (this.m_sessionInfo != null && bIncludeUserInfo) {
            VWUserInfo[] userInfoList = this.m_sessionInfo.getSession().fetchUserRecords(200, false);
            for (int i = 0; i < userInfoList.length; ++i) {
                objList.add(userInfoList[i]);
            }
        }
        if (objList.size() > 0) {
            apiObjects = new IVWtoXML[objList.size()];
            objList.copyInto(apiObjects);
        }
        return apiObjects;
    }

    public void selectExportComponents() {
        try {
            VWClassFactory.VWSystemConfiguration_setIsSelectedForExport(this.m_configuration, this.m_exportOpt == 2, 234L);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            IVWConfigTreeNode iNode = (IVWConfigTreeNode)((Object)this.getChildAt(i));
            iNode.selectExportComponents();
        }
    }

    public String fromXML(String XMLFile, int option) throws Exception {
        return VWXMLConfiguration.importConfigurationFromFile(this.m_sessionInfo.getSession(), XMLFile, option);
    }

    public void releaseResources() {
        this.m_configuration = null;
        this.m_admin = null;
        this.m_router = null;
        this.m_hostName = null;
        this.m_port = 0;
        this.m_baseURL = null;
        super.releaseResources();
    }

    private static class RegionThread
    extends Thread {
        private VWSessionInfo m_sessionInfo = null;

        public RegionThread(String theName, VWSessionInfo sessionInfo) {
            super(theName);
            try {
                this.m_sessionInfo = sessionInfo;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void run() {
            try {
                this.m_sessionInfo.logoff();
                this.m_sessionInfo = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

